using System.Diagnostics;
using System.Linq;
using gov.va.med.vbecs.Common.Log;
#if NUNIT
#region Directives
//-----------------------***
using System;
using System.Collections;
using System.Data;
using System.Text;
using NUnit.Framework;
using gov.va.med.vbecs.UnitTests;

using TABLES = gov.va.med.vbecs.Common.VbecsTables;
using SPROCS = gov.va.med.vbecs.Common.VbecsStoredProcs;
using ARTIFICIAL = gov.va.med.vbecs.Common.DatabaseConstants.ArtificialColumnNames;

using BOL = gov.va.med.vbecs.BOL;
using COMMON = gov.va.med.vbecs.Common;
using DAL = gov.va.med.vbecs.DAL;
using VAL = gov.va.med.vbecs.VAL;
using gov.va.med.vbecs.VAL.UnitTests;
//-----------------------***
using gov.va.med.vbecs.DAL.VistALink.OpenLibrary;
using System.IO;
using System.Reflection;
using System.Configuration;
using gov.va.med.vbecs.Common.AppServices;
using gov.va.med.vbecs.Common.DependencyInjection;
using Spring.Context.Support;
#endregion

namespace gov.va.med.vbecs.UnitTests
{
	/// <summary>
	/// Holds shared configuration values used across the whole VBECS unit test package.
	/// </summary>
	public class UnitTestConfig
	{
	    private static bool needInitilize = true;


		static UnitTestConfig()
		{
            if (needInitilize)
            {
                InitializeStuff();
                needInitilize = false;
            }
		    //_dbConnString = Container.GlobalContext.DbSettingsReader.PrimaryDbConnectionString;
		}

		/// <summary>
		/// Clear All Data First?
		/// </summary>
		public static bool IsAutoBuild
		{
			get
			{
				//The automated build sets this value to True, otherwise it is False
				//return System.Convert.ToBoolean(System.Configuration.ConfigurationManager.AppSettings[ "IsAutoBuild" ]);
                //Commented 10/10 trying to get away from App.config completely - BaseSetup() sets to False after first pass
                return((bool)GlobalContext.Instance().AppSettingsReader.GetValue("IsAutoBuild", typeof(bool)));
			}
		}

        private static void InitializeStuff()
        {
            //Globally setup log output file name
            log4net.GlobalContext.Properties["LogName"] = "UnitTest" + DateTime.Now.ToString("_MM-dd-yyyy");
            var log4NetFile = Path.Combine(Path.GetDirectoryName(typeof(UnitTestConfig).Assembly.Location) ?? ".", ConfigurationManager.AppSettings.Get("log4net.Config"));
            log4net.Config.XmlConfigurator.ConfigureAndWatch(new FileInfo(log4NetFile));

            //Two configuration files are necessary since object in first file should be created and ready for object in the second one.
            var common = @"file://" + Path.Combine(Environment.CurrentDirectory ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFileCommon"));
            var spring = @"file://" + Path.Combine(Environment.CurrentDirectory ?? ".", ConfigurationManager.AppSettings.Get("SpringConfigFile"));
            DiContext.AppContext = new XmlApplicationContext(new[] { common, spring });

            //Here is the once-per-class call to initialize the log object
            //We have to do it after Spring.NET objects initialization.
            var logger = LogManager.Instance().LoggerLocator.GetLogger(MethodBase.GetCurrentMethod().DeclaringType);
            logger.Debug("Spring.NET dependensies are initialized from Unit tests");
        }

	    /// <summary>
		/// Test division code to be used in unit tests.
		/// </summary>
		public static string TestDivisionCode
		{
            get 
            { 
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("TestDivisionCode", typeof(string));
                return (retValue);
            }
		}

		/// <summary>
		/// Test division name to be used in unit tests.
		/// </summary>
		public static string TestDivisionName
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("TestDivisionName", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// VistA access code used to connect to VistA system during unit testing.
		/// </summary>
		public static VistASecurityCode VistAAccessCode
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("VistALinkTestAccessCode", typeof(string));

				return new VistASecurityCode(retValue);
			}
		}

		/// <summary>
		/// VistA verify code used to connect to VistA system during unit testing.
		/// </summary>
		public static VistASecurityCode VistAVerifyCode
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("VistALinkTestVerifyCode", typeof(string));

                return new VistASecurityCode(retValue);
			}
		}

		/// <summary>
		/// VistA user DUZ used to connect to VistA system during unit testing.
		/// </summary>
		public static string VistAUserDuz
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("VistALinkTestUserDuz", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// Specifies whether VistALink connection should be physically terminated 
		/// upon calling VistALinkUnitTestHarness.ReleaseConnection().
		/// </summary>
		public static bool DoNotReleaseVistALinkConnectionImmediately
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("DoNotReleaseVistALinkConnectionImmediately", typeof(string));

				return Boolean.Parse( retValue );
			}
		}

		/// <summary>
		/// UserID for technologist
		/// </summary>
		public static string User_Technologist
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("User_Technologist", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// UserID for enhanced technologist
		/// </summary>
		public static string User_EnhancedTechnologist
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("User_EnhancedTechnologist", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// UserID for lead technologist
		/// </summary>
		public static string User_LeadTechnologist
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("User_LeadTechnologist", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// UserID for traditional supervisor
		/// </summary>
		public static string User_TraditionalSupervisor
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("User_TraditionalSupervisor", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// UserID for enhanced supervisor
		/// </summary>
		public static string User_EnhancedSupervisor
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("User_EnhancedSupervisor", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// UserID for administrator supervisor
		/// </summary>
		public static string User_AdministratorSupervisor
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("User_AdministratorSupervisor", typeof(string));
                return (retValue);
			}
		}

		/// <summary>
		/// Returns VistA ServerConnectionInfo created from app.config
		/// </summary>
		public static ServerConnectionInfo VistAServerConnectionInfo
		{
			get
			{
				return (GlobalConfig.GetServerConnectionInfoByHandle( "Primary" ));
			}
		}

		
		/// <summary>
		/// Application Name field value used in app.config of UnitTest
		/// </summary>
		public static string UnitTestConnName
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("UnitTestConnName", typeof(string));
                return (retValue);
			}
		}


		/// <summary>
		/// Unit Test DB name
		/// </summary>
		public static string DatabaseName
		{
			get
			{
                string retValue = (string)GlobalContext.Instance().AppSettingsReader.GetValue("DatabaseName", typeof(string));
                return (retValue);
			}
		}
	}
}
#endif